import gc
import ROOT
import os
import math
import sys
import time
from multiprocessing import Process,Array,Queue

ROOT.gROOT.SetBatch(True)
ROOT.TH1.AddDirectory(0);
ROOT.gStyle.SetCanvasPreferGL(1)
period=int(sys.argv[1])
fNameIn="period%i.root" % period
fNameOut="period%i_out.root" % period
fNameOutPDF="period%i_out.pdf" % period

fnameInMC="MC_100GeV.root"
fRootMC=ROOT.TFile(fnameInMC)

#dd=fRootMCmu.GetDirectory("run_%i"%run)
h0muMC=fRootMC.Get("hMu0_MC_100GeV")
h1muMC=fRootMC.Get("hMu2_MC_100GeV")
h2muMC=fRootMC.Get("hMu1_MC_100GeV")
h0dimuMC=fRootMC.Get("hDiMu0_MC_100GeV")
h1dimuMC=fRootMC.Get("hDiMu1_MC_100GeV")
h2dimuMC=fRootMC.Get("hDiMu2_MC_100GeV")
hvetomuMC=fRootMC.Get("hMuVeto_MC_100GeV")

hfull0cMC=fRootMC.Get("hFull0c_MC_100GeV")
hfull0MC=fRootMC.Get("hFull0_MC_100GeV")


runs=[]


class retV:
    def __init__(self,scale,scaleE,sigma,sigmaE):
        self.scale=scale
        self.scaleE=scaleE
        self.sigma=sigma
        self.sigmaE=sigmaE

def setGraphs(irun,runN,ret,gSigma,gScale):
    gScale.SetPoint(irun,runN,ret.scale)
    gScale.SetPointError(irun,0,ret.scaleE)
    gSigma.SetPoint(irun,runN,ret.sigma)
    gSigma.SetPointError(irun,0,ret.sigmaE)
    
        
def getRuns(fRoot):
    fRoot=ROOT.TFile(fNameIn)
    lDirs=fRoot.GetListOfKeys()
    for d in lDirs:
        run=(int)((d.GetName()).split("_")[1])
        runs.append(run)
    fRoot.Close()


#histoData is a list of histograms for DATA
#histoMC is a list of histograms for MC (create the PDF from these)
#xmin is a list of minimum x axis
#xmax is a list of maximum x axis

def doFit(histoData,histoMC,xmin,xmax,name,sigma,sigmaMin,sigmaMax,alphaIN=1):

    N=len(histoData)
    
    #create all RooRealVar
    x=[]
    for ii in range (0,N):
        x.append(ROOT.RooRealVar(name+"_x_%i"%ii,name+"_E [GeV]",xmin[ii],xmax[ii]))

    #create a global rooRealVar
    xALL=ROOT.RooArgSet(name+"_x")
    for ii in range(0,N):
        xALL.add(x[ii])
    
    # Define category to distinguish physics and control samples events
    sample = ROOT.RooCategory("sample", "sample")
    for ii in range(0,N):
        sample.defineType(name+"_sample_%i"%ii)

    #create all root data hist for DATA, prepare dictionary
    data=[]
    dictData={}
    for ii in range(0,N):
        data.append(ROOT.RooDataHist(name+("_data_%i"%ii),name+("_data_%i"%ii),x[ii],histoData[ii]))
        x[ii].setBins(data[ii].numEntries())
        dictData["range_%i"%ii]=data[ii]
        
    #create the GLOBAL dataset
    dataALL=ROOT.RooDataHist(name+"_data",name+"_data",xALL,Index=sample,Import=dictData)
    
    #create the RooRealVar for MC
    E=[]
    for ii in range(0,N):
        E.append(ROOT.RooRealVar(name+"_E_%i"%ii,name+"_E_%i"%ii, 0, 500));
        E[ii].setBins(10000,"cache")
    #create all RootDataHist for MC
    dh=[]
    dh_draw=[]
    for ii in range(0,N):
        dh.append(ROOT.RooDataHist(name+("_dh_%i"%ii),name+("_dh_%i"%ii),E[ii],histoMC[ii]));
        dh_draw.append(ROOT.RooDataHist(name+("_dh_%i"%ii),name+("_dh_%i"%ii),x[ii],histoMC[ii]));

        
    #create the scale variable for MC - assume a single scale is ok for all energy ranges.
    scale=[]
    for ii in range(0,N):
        scale.append(ROOT.RooRealVar(name+"_scale_%i"%ii,name+"_scale_%i"%ii,0.95,0.5,1.5))
    p0=ROOT.RooRealVar(name+"_p0",name+"_p0",0.)

    Qf=[]
    for ii in range(0,N):
        Qf.append(ROOT.RooPolyVar(name+"_HCAL_F_%i"%ii,name+"_HCAL_F_%i"%ii,x[ii],ROOT.RooArgSet(p0,scale[ii])))

    #create all histo PDFs for MC.
    histpdf=[]
   
    for ii in range(0,N):
        histpdf.append(ROOT.RooHistPdf(name+("_histpdf_%i"%ii),name+("_histpdf_%i"%ii),E[ii],dh[ii]))
    
    
    #TODO: gaussian model
    gauss=[]
    mg=ROOT.RooRealVar(name+"_mg",name+"_mg", 0);
    #sg=ROOT.RooRealVar(name+"_sg_%i"%ii,name+"_sg_%i"%ii,sigma,sigmaMin,sigmaMax)
    #prepare gaus PDFs
    sg=[]
    for ii in range(0,N):
        sg.append(ROOT.RooRealVar(name+"_sg_%i"%ii,name+"_sg_%i"%ii,sigma,sigmaMin,sigmaMax));
        gauss.append(ROOT.RooGaussian(name+"_gauss_%i"%ii,name+"_gauss_%i"%ii,E[ii],mg,sg[ii]))
    

        
    #create all histo PDFs for MC after smearing.
    lxg=[]
    for ii in range(0,N):
        lxg.append(ROOT.RooFFTConvPdf(name+"_lxg_%i"%ii,"histpdf (X) gauss", Qf[ii], E[ii], histpdf[ii], gauss[ii]));

    #add some dummy bck
    pol0=[]
    f0=[]
    for ii in range(0,N):
        pol0.append(ROOT.RooPolynomial(name+"_pol0_%i"%ii,name+"_pol0_%i"%ii, Qf[ii], ROOT.RooArgList()));
        f0.append(ROOT.RooRealVar(name+"_f0_%i"%ii,name+"_f0_%i"%ii, 1., 0.9, 1.0));

    #Sum model
    model=[]
    for ii in range(0,N):
        model.append(ROOT.RooAddPdf(name+"_model_%i"%ii,name+"_model_%i"%ii, ROOT.RooArgList(lxg[ii], pol0[ii]), ROOT.RooArgList(f0[ii])));

        
    #prepare the simultaneous PDF
    simPDF = ROOT.RooSimultaneous(name+"_simPDF",name+"_simPDF",sample)
    for ii in range(0,N):
        simPDF.addPdf(lxg[ii],name+"_sample_%i"%ii)
 
    #do the fit
    ##SIMULTANEOUS
    simPDF.fitTo(dataALL)

    ##ONE_BY_ONE
#    for ii in range(0,N):
#        model[ii].fitTo(data[ii])
    
    #prepare ret val
    #retVal=retV(scale.getValV(),scale.getError(),sg.getValV(),sg.getError())
    retVal=None
    #histpdf for drawing
    histpdf_MC=[]
    Qf2=[]
    histpdf_MC_SCALED=[]
    for ii in range(0,N):
        histpdf_MC.append(ROOT.RooHistPdf(name+"_histpdf_MC_%i"%ii,name+"_histpdf_MC_%i"%ii, x[ii], dh_draw[ii], 2));  
        Qf2.append(ROOT.RooPolyVar(name+"_HCAL_f2_%i"%ii, name+"_HCAL_f2_%i"%ii, x[ii], ROOT.RooArgSet(p0, scale[ii])));
        histpdf_MC_SCALED.append(ROOT.RooHistPdf(name+"_histpdf_MC_SCALED_%i"%ii,name+"_histpdf_MC_SCALED_%i"%ii, Qf2[ii], E[ii], dh[ii], 2));

    frames=[]
    for ii in range(0,N):
        frames.append(x[ii].frame())
        data[ii].plotOn(frames[ii])
        lxg[ii].plotOn(frames[ii],LineColor=ROOT.kRed)
        histpdf_MC[ii].plotOn(frames[ii],LineColor=ROOT.kGreen,LineWidth=1);
        histpdf_MC_SCALED[ii].plotOn(frames[ii],LineColor=ROOT.kBlue,LineWidth=1);
    return retVal,frames

   
    
    
def anaOneRun(ii,fRoot,run):
    print("Ana run: %i [%i]"%(ii,run))
   
   
   

    #Get the histograms for DATA
    d=fRoot.GetDirectory("run_%i"%run)
    h0mu=d.Get("hMu0_%i"%run)
    h1mu=d.Get("hMu1_%i"%run)
    h2mu=d.Get("hMu2_%i"%run)
    h0dimu=d.Get("hDiMu0_%i"%run)
    h1dimu=d.Get("hDiMu1_%i"%run)
    h2dimu=d.Get("hDiMu2_%i"%run)
    hvetomu=d.Get("hMuVeto_%i"%run)
    
    hFull0c=d.Get("hFull0c_%i"%run)
    hFull0=d.Get("hFull0_%i"%run)

    hFull1c=d.Get("hFull1c_%i"%run)
    hFull1=d.Get("hFull1_%i"%run)

    
    #REBIN DATA HERE
    hFull0c.Rebin(4)
    hFull0.Rebin(4)
    #STOP DATA REBIN

    
    
    if (h0mu==None):
        ret=[-1]
        return ret

    if ((h0mu.GetEntries()<200)or(h1mu.GetEntries()<200)or(h2mu.GetEntries()<200)):
        ret=[-2]
        return ret

    #HCAL0
    h0data=[h0mu,h0dimu,hFull0c]
    h0mc=[h0muMC,h0dimuMC,hfull0cMC]
    xmin=[0. ,0., 30.]
    xmax=[10.,15.,120.]

   
    ret0,frames0=doFit(h0data,h0mc,xmin,xmax,"hcal0",.7,0.1,10,0.95)

    #HCAL0
    h1data=[h1mu,h1dimu]
    h1mc=[h1muMC,h1dimuMC]
    xmin=[0. ,0., 30.]
    xmax=[10.,15.,120.]

   
    ret1,frames1=doFit(h1data,h1mc,xmin,xmax,"hcal1",.5,0.1,10,1.)
    
  
    c=ROOT.TCanvas("run_%i"%(run),"run_%i"%(run))
    c.Divide(3,3)
    for ii in range(0,len(frames0)):
        c.cd(ii+1)
        frames0[ii].Draw()
    for ii in range(0,len(frames1)):
        c.cd(3+ii+1)
        frames1[ii].Draw()
        
    ret=[]
    ret.append(0)
    ret.append(c.Clone())
    return ret


  
#    ret=[]
#    ret.append(0)
#    ret.append(ret0)
#    ret.append(ret1)
#    ret.append(ret2)
#    ret.append(retV)
#    ret.append(retFull0)
#    ret.append(retFull0c)
#    ret.append(retFull1)
#    ret.append(retFull1c)
#    ret.append(c.Clone())
#    return ret




#PREPARE INPUT DATA
fRoot=ROOT.TFile(fNameIn)
fRootOut=ROOT.TFile(fNameOut,"recreate")

getRuns(fRoot)

#PREPARE OUTPUT GRAPHS
gScale0=ROOT.TGraphErrors()
gScale1=ROOT.TGraphErrors()
gScale2=ROOT.TGraphErrors()
gScaleV=ROOT.TGraphErrors()
gScaleHCAL0=ROOT.TGraphErrors()
gScaleHCAL0c=ROOT.TGraphErrors()
gSigma0=ROOT.TGraphErrors()
gSigma1=ROOT.TGraphErrors()
gSigma2=ROOT.TGraphErrors()
gSigmaV=ROOT.TGraphErrors()
gSigmaHCAL0=ROOT.TGraphErrors()
gSigmaHCAL0c=ROOT.TGraphErrors()

gSigma0.SetName("gSigma0")
gSigma1.SetName("gSigma1")
gSigma2.SetName("gSigma2")
gSigmaV.SetName("gSigmaV")
gSigmaHCAL0.SetName("gSigmaHCAL0")
gSigmaHCAL0c.SetName("gSigmaHCAL0c")
gScale0.SetName("gScale0")
gScale1.SetName("gScale1")
gScale2.SetName("gScale2")
gScaleV.SetName("gScaleV")
gScaleHCAL0.SetName("gScaleHCAL0")
gScaleHCAL0c.SetName("gScaleHCAL0c")

gSigma0.SetTitle("HCAL-0-1-1 MIP #sigma;run n.; #sigma [GeV]")
gSigma1.SetTitle("HCAL-1-1-1 MIP #sigma;run n.; #sigma [GeV]")
gSigma2.SetTitle("HCAL-2-1-1 MIP #sigma;run n.; #sigma [GeV]")
gSigmaV.SetTitle("VETO_central MIP #sigma;run n.; #sigma [GeV]")
gScale0.SetTitle("HCAL-0-1-1 MIP #alpha;run n.; #alpha")
gScale1.SetTitle("HCAL-1-1-1 MIP #alpha;run n.; #alpha")
gScale2.SetTitle("HCAL-2-1-1 MIP #alpha;run n.; #alpha")
gScaleV.SetTitle("VETO-central MIP #alpha; run n.; #alpha")

#REBIN HERE MC
#h0muMC=fRootMC.Get("hMu0_MC_100GeV")
#h1muMC=fRootMC.Get("hMu2_MC_100GeV")
#h2muMC=fRootMC.Get("hMu1_MC_100GeV")
#hvetomuMC=fRootMC.Get("hMuVeto_MC_100GeV")

hfull0cMC.Rebin(4)
hfull0MC.Rebin(4)

hfull1_all=None
hfull1c_all=None


irun=0
for run in runs:
    ret=anaOneRun(irun,fRoot,run)

    
    if (ret[0]<0):
        continue

    #if (irun==0):
    #    hfull1_all=ret[7]
    #    hfull1c_all=ret[8]
    #    hfull1_all.SetName("hfull1")
    #    hfull1c_all.SetName("hfull1c")
    #else:
    #    hfull1_all.Add(ret[7])
    #    hfull1c_all.Add(ret[8])
    
    #setGraphs(irun,run,ret[1],gSigma0,gScale0)
    #setGraphs(irun,run,ret[2],gSigma1,gScale1)
    #setGraphs(irun,run,ret[3],gSigma2,gScale2)
    #setGraphs(irun,run,ret[4],gSigmaV,gScaleV)
    #setGraphs(irun,run,ret[5],gSigmaHCAL0,gScaleHCAL0)
    #setGraphs(irun,run,ret[6],gSigmaHCAL0c,gScaleHCAL0c)
    
    c=ret[-1]
    
    if (irun==0):
        c.Print(fNameOutPDF+"(","Title:Run %i" % (run))
    else:
        c.Print(fNameOutPDF,"Title:Run %i" % (run))

    fRootOut.cd()
    fRootOut.mkdir("run_%i"%run)
    fRootOut.cd("run_%i"%run)
        
    c.Write()
    irun=irun+1
    

fRootOut.cd()
gScale0.Write()
gScale1.Write()
gScale2.Write()
gScaleV.Write()
gScaleHCAL0.Write()
gScaleHCAL0c.Write()
gSigma0.Write()
gSigma1.Write()
gSigma2.Write()
gSigmaV.Write()
gSigmaHCAL0.Write()
gSigmaHCAL0c.Write()

#hfull1_all.Write()
#hfull1c_all.Write()


cF=ROOT.TCanvas("cF","cF")
g=ROOT.TMultiGraph("g","HCAL MIP #sigma ; run n. ; #sigma ")

gSigma1.SetLineColor(2)
gSigma1.SetMarkerColor(2)
gSigma2.SetLineColor(3)
gSigma2.SetMarkerColor(3)

g.Add(gSigma0,"P")
g.Add(gSigma1,"P")
g.Add(gSigma2,"P")
g.Draw("A")
cF.BuildLegend()
cF.Print(fNameOutPDF)



g=ROOT.TMultiGraph("g","HCAL MIP #alpha ; run n. ; #alpha ")
gScale1.SetLineColor(2)
gScale1.SetMarkerColor(2)
gScale2.SetLineColor(3)
gScale2.SetMarkerColor(3)
g.Add(gScale0,"P")
g.Add(gScale1,"P")
g.Add(gScale2,"P")
#g.GetYaxis().SetRangeUser(0.5,1.5)
#g.GetYaxis().SetMaxDigits(2)
g.Draw("A")
cF.BuildLegend()
cF.Print(fNameOutPDF)

g=ROOT.TMultiGraph("g","HCAL full energy #alpha ; run n. ; #alpha ")
gScaleHCAL0c.SetLineColor(2)
gScaleHCAL0c.SetMarkerColor(2)
g.Add(gScaleHCAL0,"P")
g.Add(gScaleHCAL0c,"P")
#g.GetYaxis().SetRangeUser(0.5,1.5)
#g.GetYaxis().SetMaxDigits(2)
g.Draw("A")
cF.BuildLegend()
cF.Print(fNameOutPDF)



g=ROOT.TMultiGraph("g","HCAL full energy #sigma ; run n. ; #sigma ")
gSigmaHCAL0c.SetLineColor(2)
gSigmaHCAL0c.SetMarkerColor(2)
g.Add(gSigmaHCAL0,"P")
g.Add(gSigmaHCAL0c,"P")
#g.GetYaxis().SetMaxDigits(2)
g.Draw("A")
#g.GetYaxis().SetMaxDigits(2)
cF.BuildLegend()
cF.Print(fNameOutPDF)


gScaleV.Draw("AP")
cF.Print(fNameOutPDF)

gSigmaV.GetYaxis().SetRangeUser(0,0.002)
gSigmaV.GetYaxis().SetMaxDigits(2);
gSigmaV.Draw("AP")
cF.Print(fNameOutPDF+")")


fRootOut.Close()

 
